#
# The following is an example of how to retrieve data from TRACE 
# heat structure components.
# The calculations performed with this data are not necessarily usefull or
# appropriate but serve only as examples of how the values used can be retrieved
# from the model.
#
#

# Pre-Defined Methods:

### 
 # Retrieves the current model.
 # In batch mode the model retrieved is either the current model
 # (the last model opened, imported, etc.) or the model specified
 # by key in the MACRO command.
###
# def getModel():

### 
 # Prints the given message to the Message Window as a Notice.
###
# def addMessage(message):
addMessage( "Beginning Python data access example for TRACE HTSTR using W4loopn.med")

#
# In the following example, various values of HTSTR #173 will be displayed
# as messages in the Message Window
#

# Find htstr number 173 by using it's component number and category name.
htstr = findComponent("Heat Structures",173)
# Note: The category name is the name of the category as it appears in
#       the Navigator. Using the singular "Heat Structure" in this case will not
#       find the component and will throw an exception.

# Print the component's string representation to the Message Window
addMessage( "Example Component: "+str(htstr) )

# This is a set of lines from the HTSTR ASCII export routine rewritten in python. 
addMessage( "*******   type        num        userid     component name")
addMessage( "htstr                 %3d             %d    %s" \
                # the htstr's component number
            % ( htstr.getComponentNumber(), \
                # Arbitrary user-defined ID
                0, \
                # the toString of the component.
                htstr.toString()) ) 
                # toString() generates a human-readable string representation 
                # of the component for use in messages, selections, etc.

# This set shows a set of basic HTSTR real values.
# The toString() of each real is used to display the values.
addMessage("*     dtxht(1)      dtxht(2)         dznht         hgapo")
addMessage(" %13s %13s %13s %13s" % \
           (htstr.getDtxht1(), htstr.getDtxht2(), \
            htstr.getDznht(), htstr.getHgapo() ) )

#
# This block shows an example of retrieving heat cell and surface
# values for a htstr.
# In this example the cell's length and inner surface heat flux
# is displayed.
#
nzhstr = htstr.getCellsCount() # number of axial heat cells
nodes = htstr.getNodes()       # number of radial nodes

addMessage("Cell Length and Inner Surface Heat Flux")
addMessage( "%6s %14s %14s" %("cell","length","inner flux") )
cell = 0 # current axial heat cell
while cell < nzhstr:
    c = htstr.getCells(cell)
    addMessage( "%6s %14s %14s" \
                %( cell+1, \
                   c.getDhtstrz().toString(), \
                   c.getInner().getQflxbc().toString() ) )
    cell += 1
#
# This block is an example of access for each of the average rod
# initial temperatures for the HTSTR.
#
# The initial temperatures are stored in an array of SurfaceTemp
# blocks inside the HTSTR, one per axial cell. 
# Each of these SurfaceTemps has an array of temperatures,
# one per radial node.
#
addMessage("Initial Temperatures")
addMessage( "%6s %6s %14s" %("axial","radial","RFTN") )
cell = 0 # current axial heat cell
while cell < nzhstr:
    node = 0 # current radial node
    while node < nodes:
        addMessage( "%6s %6s %14s" % \
                    (cell, node, htstr.getRftn(cell).getTemperature(node).toString()) )
        node += 1 #next radial node
    cell += 1 #next axial cell

